package io.k8s.kube_aggregator.pkg.apis.apiregistration.v1

import dev.hnaderi.k8s._

/** APIServiceList is a list of APIService objects. */
final case class APIServiceList(
  items : Seq[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIService],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apiregistration.k8s.io", "APIServiceList", "v1")

  def withItems(value: Seq[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIService]) : APIServiceList = copy(items = value)
  def addItems(newValues: io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIService*) : APIServiceList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : APIServiceList = copy(metadata = Some(value))
}

