package io.k8s.kube_aggregator.pkg.apis.apiregistration.v1

import dev.hnaderi.k8s._

/** APIService represents a server for a particular GroupVersion. Name must be "version.group". */
final case class APIService(
  status : Option[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceStatus] = None,
  spec : Option[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apiregistration.k8s.io", "APIService", "v1")

  def withStatus(value: io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceStatus) : APIService = copy(status = Some(value))
  def withSpec(value: io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceSpec) : APIService = copy(spec = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : APIService = copy(metadata = Some(value))
}

