package io.k8s.apimachinery.pkg.apis.meta.v1


/** StatusCause provides more information about an api.Status failure, including cases when multiple errors are encountered. */
final case class StatusCause(
  field : Option[String] = None,
  message : Option[String] = None,
  reason : Option[String] = None
) {
  def withField(value: String) : StatusCause = copy(field = Some(value))
  def withMessage(value: String) : StatusCause = copy(message = Some(value))
  def withReason(value: String) : StatusCause = copy(reason = Some(value))
}

