package io.k8s.apimachinery.pkg.apis.meta.v1


/** OwnerReference contains enough information to let you identify an owning object. An owning object must be in the same namespace as the dependent, or be cluster-scoped, so there is no namespace field. */
final case class OwnerReference(
  name : String,
  blockOwnerDeletion : Option[Boolean] = None,
  uid : String,
  controller : Option[Boolean] = None
) {
  def withName(value: String) : OwnerReference = copy(name = value)
  def withBlockOwnerDeletion(value: Boolean) : OwnerReference = copy(blockOwnerDeletion = Some(value))
  def withUid(value: String) : OwnerReference = copy(uid = value)
  def withController(value: Boolean) : OwnerReference = copy(controller = Some(value))
}

