package io.k8s.apimachinery.pkg.apis.meta.v1


/** ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create. */
final case class ObjectMeta(
  name : Option[String] = None,
  ownerReferences : Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference]] = None,
  creationTimestamp : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  generation : Option[Int] = None,
  resourceVersion : Option[String] = None,
  generateName : Option[String] = None,
  deletionGracePeriodSeconds : Option[Int] = None,
  selfLink : Option[String] = None,
  finalizers : Option[Seq[String]] = None,
  annotations : Option[Map[String, String]] = None,
  managedFields : Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry]] = None,
  labels : Option[Map[String, String]] = None,
  uid : Option[String] = None,
  namespace : Option[String] = None,
  deletionTimestamp : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None
) {
  def withName(value: String) : ObjectMeta = copy(name = Some(value))
  def withOwnerReferences(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference]) : ObjectMeta = copy(ownerReferences = Some(value))
  def addOwnerReferences(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference*) : ObjectMeta = copy(ownerReferences = Some(ownerReferences.fold(newValues)(_ ++ newValues)))

  def withCreationTimestamp(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ObjectMeta = copy(creationTimestamp = Some(value))
  def withGeneration(value: Int) : ObjectMeta = copy(generation = Some(value))
  def withResourceVersion(value: String) : ObjectMeta = copy(resourceVersion = Some(value))
  def withGenerateName(value: String) : ObjectMeta = copy(generateName = Some(value))
  def withDeletionGracePeriodSeconds(value: Int) : ObjectMeta = copy(deletionGracePeriodSeconds = Some(value))
  def withSelfLink(value: String) : ObjectMeta = copy(selfLink = Some(value))
  def withFinalizers(value: Seq[String]) : ObjectMeta = copy(finalizers = Some(value))
  def addFinalizers(newValues: String*) : ObjectMeta = copy(finalizers = Some(finalizers.fold(newValues)(_ ++ newValues)))

  def withAnnotations(value: Map[String, String]) : ObjectMeta = copy(annotations = Some(value))
  def addAnnotations(newValues: (String, String)*) : ObjectMeta = copy(annotations = Some(annotations.fold(newValues.toMap)(_ ++ newValues)))

  def withManagedFields(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry]) : ObjectMeta = copy(managedFields = Some(value))
  def addManagedFields(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry*) : ObjectMeta = copy(managedFields = Some(managedFields.fold(newValues)(_ ++ newValues)))

  def withLabels(value: Map[String, String]) : ObjectMeta = copy(labels = Some(value))
  def addLabels(newValues: (String, String)*) : ObjectMeta = copy(labels = Some(labels.fold(newValues.toMap)(_ ++ newValues)))

  def withUid(value: String) : ObjectMeta = copy(uid = Some(value))
  def withNamespace(value: String) : ObjectMeta = copy(namespace = Some(value))
  def withDeletionTimestamp(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ObjectMeta = copy(deletionTimestamp = Some(value))
}

