package io.k8s.apimachinery.pkg.apis.meta.v1


/** ManagedFieldsEntry is a workflow-id, a FieldSet and the group version of the resource that the fieldset applies to. */
final case class ManagedFieldsEntry(
  operation : Option[String] = None,
  manager : Option[String] = None,
  fieldsV1 : Option[io.k8s.apimachinery.pkg.apis.meta.v1.FieldsV1] = None,
  time : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  fieldsType : Option[String] = None,
  subresource : Option[String] = None
) {
  def withOperation(value: String) : ManagedFieldsEntry = copy(operation = Some(value))
  def withManager(value: String) : ManagedFieldsEntry = copy(manager = Some(value))
  def withFieldsV1(value: io.k8s.apimachinery.pkg.apis.meta.v1.FieldsV1) : ManagedFieldsEntry = copy(fieldsV1 = Some(value))
  def withTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ManagedFieldsEntry = copy(time = Some(value))
  def withFieldsType(value: String) : ManagedFieldsEntry = copy(fieldsType = Some(value))
  def withSubresource(value: String) : ManagedFieldsEntry = copy(subresource = Some(value))
}

