package io.k8s.apimachinery.pkg.apis.meta.v1


/** A label selector is a label query over a set of resources. The result of matchLabels and matchExpressions are ANDed. An empty label selector matches all objects. A null label selector matches no objects. */
final case class LabelSelector(
  matchExpressions : Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement]] = None,
  matchLabels : Option[Map[String, String]] = None
) {
  def withMatchExpressions(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement]) : LabelSelector = copy(matchExpressions = Some(value))
  def addMatchExpressions(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement*) : LabelSelector = copy(matchExpressions = Some(matchExpressions.fold(newValues)(_ ++ newValues)))

  def withMatchLabels(value: Map[String, String]) : LabelSelector = copy(matchLabels = Some(value))
  def addMatchLabels(newValues: (String, String)*) : LabelSelector = copy(matchLabels = Some(matchLabels.fold(newValues.toMap)(_ ++ newValues)))

}

