package io.k8s.apimachinery.pkg.apis.meta.v1


/** GroupVersion contains the "group/version" and "version" string of a version. It is made a struct to keep extensibility. */
final case class GroupVersionForDiscovery(
  groupVersion : String,
  version : String
) {
  def withGroupVersion(value: String) : GroupVersionForDiscovery = copy(groupVersion = value)
  def withVersion(value: String) : GroupVersionForDiscovery = copy(version = value)
}

