package io.k8s.apimachinery.pkg.apis.meta.v1


/** Condition contains details for one aspect of the current state of this API Resource. */
final case class Condition(
  reason : String,
  status : String,
  observedGeneration : Option[Int] = None,
  lastTransitionTime : io.k8s.apimachinery.pkg.apis.meta.v1.Time,
  message : String,
  `type` : String
) {
  def withReason(value: String) : Condition = copy(reason = value)
  def withStatus(value: String) : Condition = copy(status = value)
  def withObservedGeneration(value: Int) : Condition = copy(observedGeneration = Some(value))
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : Condition = copy(lastTransitionTime = value)
  def withMessage(value: String) : Condition = copy(message = value)
  def withType(value: String) : Condition = copy(`type` = value)
}

