package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s._

/** APIVersions lists the versions that are available, to allow clients to discover the API at /api, which is the root path of the legacy v1 API. */
final case class APIVersions(
  serverAddressByClientCIDRs : Seq[io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR],
  versions : Seq[String]
) extends KObject {
  protected val _resourceKind = ResourceKind("", "APIVersions", "v1")

  def withServerAddressByClientCIDRs(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR]) : APIVersions = copy(serverAddressByClientCIDRs = value)
  def addServerAddressByClientCIDRs(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR*) : APIVersions = copy(serverAddressByClientCIDRs = serverAddressByClientCIDRs ++ newValues)

  def withVersions(value: Seq[String]) : APIVersions = copy(versions = value)
  def addVersions(newValues: String*) : APIVersions = copy(versions = versions ++ newValues)

}

