package io.k8s.apimachinery.pkg.apis.meta.v1


/** APIResource specifies the name of a resource and whether it is namespaced. */
final case class APIResource(
  name : String,
  verbs : Seq[String],
  version : Option[String] = None,
  categories : Option[Seq[String]] = None,
  namespaced : Boolean,
  shortNames : Option[Seq[String]] = None,
  storageVersionHash : Option[String] = None,
  singularName : String,
  group : Option[String] = None
) {
  def withName(value: String) : APIResource = copy(name = value)
  def withVerbs(value: Seq[String]) : APIResource = copy(verbs = value)
  def addVerbs(newValues: String*) : APIResource = copy(verbs = verbs ++ newValues)

  def withVersion(value: String) : APIResource = copy(version = Some(value))
  def withCategories(value: Seq[String]) : APIResource = copy(categories = Some(value))
  def addCategories(newValues: String*) : APIResource = copy(categories = Some(categories.fold(newValues)(_ ++ newValues)))

  def withNamespaced(value: Boolean) : APIResource = copy(namespaced = value)
  def withShortNames(value: Seq[String]) : APIResource = copy(shortNames = Some(value))
  def addShortNames(newValues: String*) : APIResource = copy(shortNames = Some(shortNames.fold(newValues)(_ ++ newValues)))

  def withStorageVersionHash(value: String) : APIResource = copy(storageVersionHash = Some(value))
  def withSingularName(value: String) : APIResource = copy(singularName = value)
  def withGroup(value: String) : APIResource = copy(group = Some(value))
}

