package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s._

/** APIGroupList is a list of APIGroup, to allow clients to discover the API at /apis. */
final case class APIGroupList(
  groups : Seq[io.k8s.apimachinery.pkg.apis.meta.v1.APIGroup]
) extends KObject {
  protected val _resourceKind = ResourceKind("", "APIGroupList", "v1")

  def withGroups(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.APIGroup]) : APIGroupList = copy(groups = value)
  def addGroups(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.APIGroup*) : APIGroupList = copy(groups = groups ++ newValues)

}

