package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s._

/** APIGroup contains the name, the supported versions, and the preferred version of a group. */
final case class APIGroup(
  name : String,
  preferredVersion : Option[io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery] = None,
  versions : Seq[io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery],
  serverAddressByClientCIDRs : Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR]] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "APIGroup", "v1")

  def withName(value: String) : APIGroup = copy(name = value)
  def withPreferredVersion(value: io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery) : APIGroup = copy(preferredVersion = Some(value))
  def withVersions(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery]) : APIGroup = copy(versions = value)
  def addVersions(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery*) : APIGroup = copy(versions = versions ++ newValues)

  def withServerAddressByClientCIDRs(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR]) : APIGroup = copy(serverAddressByClientCIDRs = Some(value))
  def addServerAddressByClientCIDRs(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR*) : APIGroup = copy(serverAddressByClientCIDRs = Some(serverAddressByClientCIDRs.fold(newValues)(_ ++ newValues)))

}

