package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1


/** ValidationRule describes a validation rule written in the CEL expression language. */
final case class ValidationRule(
  message : Option[String] = None,
  rule : String
) {
  def withMessage(value: String) : ValidationRule = copy(message = Some(value))
  def withRule(value: String) : ValidationRule = copy(rule = value)
}

