package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1


/** JSONSchemaProps is a JSON-Schema following Specification Draft 4 (http://json-schema.org/). */
final case class JSONSchemaProps(
  exclusiveMaximum : Option[Boolean] = None,
  format : Option[String] = None,
  $ref : Option[String] = None,
  nullable : Option[Boolean] = None,
  `x-kubernetes-map-type` : Option[String] = None,
  pattern : Option[String] = None,
  description : Option[String] = None,
  anyOf : Option[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]] = None,
  `x-kubernetes-list-type` : Option[String] = None,
  patternProperties : Option[Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]] = None,
  items : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrArray] = None,
  additionalItems : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrBool] = None,
  maxProperties : Option[Int] = None,
  maxItems : Option[Int] = None,
  `x-kubernetes-int-or-string` : Option[Boolean] = None,
  `x-kubernetes-embedded-resource` : Option[Boolean] = None,
  maximum : Option[Double] = None,
  multipleOf : Option[Double] = None,
  id : Option[String] = None,
  properties : Option[Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]] = None,
  exclusiveMinimum : Option[Boolean] = None,
  `x-kubernetes-validations` : Option[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule]] = None,
  `enum` : Option[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON]] = None,
  `x-kubernetes-preserve-unknown-fields` : Option[Boolean] = None,
  additionalProperties : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrBool] = None,
  default : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON] = None,
  minItems : Option[Int] = None,
  not : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps] = None,
  definitions : Option[Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]] = None,
  minLength : Option[Int] = None,
  `x-kubernetes-list-map-keys` : Option[Seq[String]] = None,
  title : Option[String] = None,
  minimum : Option[Double] = None,
  `type` : Option[String] = None,
  required : Option[Seq[String]] = None,
  example : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON] = None,
  $schema : Option[String] = None,
  oneOf : Option[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]] = None,
  uniqueItems : Option[Boolean] = None,
  minProperties : Option[Int] = None,
  dependencies : Option[Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrStringArray]] = None,
  externalDocs : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ExternalDocumentation] = None,
  maxLength : Option[Int] = None,
  allOf : Option[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]] = None
) {
  def withExclusiveMaximum(value: Boolean) : JSONSchemaProps = copy(exclusiveMaximum = Some(value))
  def withFormat(value: String) : JSONSchemaProps = copy(format = Some(value))
  def with$ref(value: String) : JSONSchemaProps = copy($ref = Some(value))
  def withNullable(value: Boolean) : JSONSchemaProps = copy(nullable = Some(value))
  def withXKubernetesMapType(value: String) : JSONSchemaProps = copy(`x-kubernetes-map-type` = Some(value))
  def withPattern(value: String) : JSONSchemaProps = copy(pattern = Some(value))
  def withDescription(value: String) : JSONSchemaProps = copy(description = Some(value))
  def withAnyOf(value: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]) : JSONSchemaProps = copy(anyOf = Some(value))
  def addAnyOf(newValues: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps*) : JSONSchemaProps = copy(anyOf = Some(anyOf.fold(newValues)(_ ++ newValues)))

  def withXKubernetesListType(value: String) : JSONSchemaProps = copy(`x-kubernetes-list-type` = Some(value))
  def withPatternProperties(value: Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]) : JSONSchemaProps = copy(patternProperties = Some(value))
  def addPatternProperties(newValues: (String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps)*) : JSONSchemaProps = copy(patternProperties = Some(patternProperties.fold(newValues.toMap)(_ ++ newValues)))

  def withItems(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrArray) : JSONSchemaProps = copy(items = Some(value))
  def withAdditionalItems(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrBool) : JSONSchemaProps = copy(additionalItems = Some(value))
  def withMaxProperties(value: Int) : JSONSchemaProps = copy(maxProperties = Some(value))
  def withMaxItems(value: Int) : JSONSchemaProps = copy(maxItems = Some(value))
  def withXKubernetesIntOrString(value: Boolean) : JSONSchemaProps = copy(`x-kubernetes-int-or-string` = Some(value))
  def withXKubernetesEmbeddedResource(value: Boolean) : JSONSchemaProps = copy(`x-kubernetes-embedded-resource` = Some(value))
  def withMaximum(value: Double) : JSONSchemaProps = copy(maximum = Some(value))
  def withMultipleOf(value: Double) : JSONSchemaProps = copy(multipleOf = Some(value))
  def withId(value: String) : JSONSchemaProps = copy(id = Some(value))
  def withProperties(value: Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]) : JSONSchemaProps = copy(properties = Some(value))
  def addProperties(newValues: (String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps)*) : JSONSchemaProps = copy(properties = Some(properties.fold(newValues.toMap)(_ ++ newValues)))

  def withExclusiveMinimum(value: Boolean) : JSONSchemaProps = copy(exclusiveMinimum = Some(value))
  def withXKubernetesValidations(value: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule]) : JSONSchemaProps = copy(`x-kubernetes-validations` = Some(value))
  def addXKubernetesValidations(newValues: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule*) : JSONSchemaProps = copy(`x-kubernetes-validations` = Some(`x-kubernetes-validations`.fold(newValues)(_ ++ newValues)))

  def withEnum(value: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON]) : JSONSchemaProps = copy(`enum` = Some(value))
  def addEnum(newValues: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON*) : JSONSchemaProps = copy(`enum` = Some(`enum`.fold(newValues)(_ ++ newValues)))

  def withXKubernetesPreserveUnknownFields(value: Boolean) : JSONSchemaProps = copy(`x-kubernetes-preserve-unknown-fields` = Some(value))
  def withAdditionalProperties(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrBool) : JSONSchemaProps = copy(additionalProperties = Some(value))
  def withDefault(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON) : JSONSchemaProps = copy(default = Some(value))
  def withMinItems(value: Int) : JSONSchemaProps = copy(minItems = Some(value))
  def withNot(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps) : JSONSchemaProps = copy(not = Some(value))
  def withDefinitions(value: Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]) : JSONSchemaProps = copy(definitions = Some(value))
  def addDefinitions(newValues: (String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps)*) : JSONSchemaProps = copy(definitions = Some(definitions.fold(newValues.toMap)(_ ++ newValues)))

  def withMinLength(value: Int) : JSONSchemaProps = copy(minLength = Some(value))
  def withXKubernetesListMapKeys(value: Seq[String]) : JSONSchemaProps = copy(`x-kubernetes-list-map-keys` = Some(value))
  def addXKubernetesListMapKeys(newValues: String*) : JSONSchemaProps = copy(`x-kubernetes-list-map-keys` = Some(`x-kubernetes-list-map-keys`.fold(newValues)(_ ++ newValues)))

  def withTitle(value: String) : JSONSchemaProps = copy(title = Some(value))
  def withMinimum(value: Double) : JSONSchemaProps = copy(minimum = Some(value))
  def withType(value: String) : JSONSchemaProps = copy(`type` = Some(value))
  def withRequired(value: Seq[String]) : JSONSchemaProps = copy(required = Some(value))
  def addRequired(newValues: String*) : JSONSchemaProps = copy(required = Some(required.fold(newValues)(_ ++ newValues)))

  def withExample(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON) : JSONSchemaProps = copy(example = Some(value))
  def with$schema(value: String) : JSONSchemaProps = copy($schema = Some(value))
  def withOneOf(value: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]) : JSONSchemaProps = copy(oneOf = Some(value))
  def addOneOf(newValues: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps*) : JSONSchemaProps = copy(oneOf = Some(oneOf.fold(newValues)(_ ++ newValues)))

  def withUniqueItems(value: Boolean) : JSONSchemaProps = copy(uniqueItems = Some(value))
  def withMinProperties(value: Int) : JSONSchemaProps = copy(minProperties = Some(value))
  def withDependencies(value: Map[String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrStringArray]) : JSONSchemaProps = copy(dependencies = Some(value))
  def addDependencies(newValues: (String, io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrStringArray)*) : JSONSchemaProps = copy(dependencies = Some(dependencies.fold(newValues.toMap)(_ ++ newValues)))

  def withExternalDocs(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ExternalDocumentation) : JSONSchemaProps = copy(externalDocs = Some(value))
  def withMaxLength(value: Int) : JSONSchemaProps = copy(maxLength = Some(value))
  def withAllOf(value: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps]) : JSONSchemaProps = copy(allOf = Some(value))
  def addAllOf(newValues: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps*) : JSONSchemaProps = copy(allOf = Some(allOf.fold(newValues)(_ ++ newValues)))

}

