package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1


/** ExternalDocumentation allows referencing an external resource for extended documentation. */
final case class ExternalDocumentation(
  description : Option[String] = None,
  url : Option[String] = None
) {
  def withDescription(value: String) : ExternalDocumentation = copy(description = Some(value))
  def withUrl(value: String) : ExternalDocumentation = copy(url = Some(value))
}

