package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1


/** CustomResourceDefinitionVersion describes a version for CRD. */
final case class CustomResourceDefinitionVersion(
  name : String,
  deprecationWarning : Option[String] = None,
  served : Boolean,
  deprecated : Option[Boolean] = None,
  subresources : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources] = None,
  schema : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation] = None,
  additionalPrinterColumns : Option[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition]] = None,
  storage : Boolean
) {
  def withName(value: String) : CustomResourceDefinitionVersion = copy(name = value)
  def withDeprecationWarning(value: String) : CustomResourceDefinitionVersion = copy(deprecationWarning = Some(value))
  def withServed(value: Boolean) : CustomResourceDefinitionVersion = copy(served = value)
  def withDeprecated(value: Boolean) : CustomResourceDefinitionVersion = copy(deprecated = Some(value))
  def withSubresources(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources) : CustomResourceDefinitionVersion = copy(subresources = Some(value))
  def withSchema(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation) : CustomResourceDefinitionVersion = copy(schema = Some(value))
  def withAdditionalPrinterColumns(value: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition]) : CustomResourceDefinitionVersion = copy(additionalPrinterColumns = Some(value))
  def addAdditionalPrinterColumns(newValues: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition*) : CustomResourceDefinitionVersion = copy(additionalPrinterColumns = Some(additionalPrinterColumns.fold(newValues)(_ ++ newValues)))

  def withStorage(value: Boolean) : CustomResourceDefinitionVersion = copy(storage = value)
}

