package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1


/** CustomResourceDefinitionStatus indicates the state of the CustomResourceDefinition */
final case class CustomResourceDefinitionStatus(
  acceptedNames : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames] = None,
  conditions : Option[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionCondition]] = None,
  storedVersions : Option[Seq[String]] = None
) {
  def withAcceptedNames(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames) : CustomResourceDefinitionStatus = copy(acceptedNames = Some(value))
  def withConditions(value: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionCondition]) : CustomResourceDefinitionStatus = copy(conditions = Some(value))
  def addConditions(newValues: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionCondition*) : CustomResourceDefinitionStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))

  def withStoredVersions(value: Seq[String]) : CustomResourceDefinitionStatus = copy(storedVersions = Some(value))
  def addStoredVersions(newValues: String*) : CustomResourceDefinitionStatus = copy(storedVersions = Some(storedVersions.fold(newValues)(_ ++ newValues)))

}

