package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1


/** CustomResourceDefinitionSpec describes how a user wants their resource to appear */
final case class CustomResourceDefinitionSpec(
  conversion : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion] = None,
  versions : Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion],
  scope : String,
  names : io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames,
  preserveUnknownFields : Option[Boolean] = None,
  group : String
) {
  def withConversion(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion) : CustomResourceDefinitionSpec = copy(conversion = Some(value))
  def withVersions(value: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion]) : CustomResourceDefinitionSpec = copy(versions = value)
  def addVersions(newValues: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion*) : CustomResourceDefinitionSpec = copy(versions = versions ++ newValues)

  def withScope(value: String) : CustomResourceDefinitionSpec = copy(scope = value)
  def withNames(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames) : CustomResourceDefinitionSpec = copy(names = value)
  def withPreserveUnknownFields(value: Boolean) : CustomResourceDefinitionSpec = copy(preserveUnknownFields = Some(value))
  def withGroup(value: String) : CustomResourceDefinitionSpec = copy(group = value)
}

