package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1


/** CustomResourceDefinitionCondition contains details for the current condition of this pod. */
final case class CustomResourceDefinitionCondition(
  reason : Option[String] = None,
  status : String,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None,
  `type` : String
) {
  def withReason(value: String) : CustomResourceDefinitionCondition = copy(reason = Some(value))
  def withStatus(value: String) : CustomResourceDefinitionCondition = copy(status = value)
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : CustomResourceDefinitionCondition = copy(lastTransitionTime = Some(value))
  def withMessage(value: String) : CustomResourceDefinitionCondition = copy(message = Some(value))
  def withType(value: String) : CustomResourceDefinitionCondition = copy(`type` = value)
}

