package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1

import dev.hnaderi.k8s._

/** CustomResourceDefinition represents a resource that should be exposed on the API server.  Its name MUST be in the format <.spec.name>.<.spec.group>. */
final case class CustomResourceDefinition(
  status : Option[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionStatus] = None,
  spec : io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apiextensions.k8s.io", "CustomResourceDefinition", "v1")

  def withStatus(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionStatus) : CustomResourceDefinition = copy(status = Some(value))
  def withSpec(value: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec) : CustomResourceDefinition = copy(spec = value)
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : CustomResourceDefinition = copy(metadata = Some(value))
}

