package io.k8s.api.storage.v1


/** VolumeAttachmentSpec is the specification of a VolumeAttachment request. */
final case class VolumeAttachmentSpec(
  attacher : String,
  nodeName : String,
  source : io.k8s.api.storage.v1.VolumeAttachmentSource
) {
  def withAttacher(value: String) : VolumeAttachmentSpec = copy(attacher = value)
  def withNodeName(value: String) : VolumeAttachmentSpec = copy(nodeName = value)
  def withSource(value: io.k8s.api.storage.v1.VolumeAttachmentSource) : VolumeAttachmentSpec = copy(source = value)
}

