package io.k8s.api.storage.v1

import dev.hnaderi.k8s._

/** VolumeAttachmentList is a collection of VolumeAttachment objects. */
final case class VolumeAttachmentList(
  items : Seq[io.k8s.api.storage.v1.VolumeAttachment],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("storage.k8s.io", "VolumeAttachmentList", "v1")

  def withItems(value: Seq[io.k8s.api.storage.v1.VolumeAttachment]) : VolumeAttachmentList = copy(items = value)
  def addItems(newValues: io.k8s.api.storage.v1.VolumeAttachment*) : VolumeAttachmentList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : VolumeAttachmentList = copy(metadata = Some(value))
}

