package io.k8s.api.storage.v1

import dev.hnaderi.k8s._

/** StorageClassList is a collection of storage classes. */
final case class StorageClassList(
  items : Seq[io.k8s.api.storage.v1.StorageClass],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("storage.k8s.io", "StorageClassList", "v1")

  def withItems(value: Seq[io.k8s.api.storage.v1.StorageClass]) : StorageClassList = copy(items = value)
  def addItems(newValues: io.k8s.api.storage.v1.StorageClass*) : StorageClassList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : StorageClassList = copy(metadata = Some(value))
}

