package io.k8s.api.storage.v1

import dev.hnaderi.k8s._

/** StorageClass describes the parameters for a class of storage for which PersistentVolumes can be dynamically provisioned.

StorageClasses are non-namespaced; the name of the storage class according to etcd is in ObjectMeta.Name. */
final case class StorageClass(
  mountOptions : Option[Seq[String]] = None,
  reclaimPolicy : Option[String] = None,
  volumeBindingMode : Option[String] = None,
  provisioner : String,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  allowVolumeExpansion : Option[Boolean] = None,
  allowedTopologies : Option[Seq[io.k8s.api.core.v1.TopologySelectorTerm]] = None,
  parameters : Option[Map[String, String]] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("storage.k8s.io", "StorageClass", "v1")

  def withMountOptions(value: Seq[String]) : StorageClass = copy(mountOptions = Some(value))
  def addMountOptions(newValues: String*) : StorageClass = copy(mountOptions = Some(mountOptions.fold(newValues)(_ ++ newValues)))

  def withReclaimPolicy(value: String) : StorageClass = copy(reclaimPolicy = Some(value))
  def withVolumeBindingMode(value: String) : StorageClass = copy(volumeBindingMode = Some(value))
  def withProvisioner(value: String) : StorageClass = copy(provisioner = value)
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : StorageClass = copy(metadata = Some(value))
  def withAllowVolumeExpansion(value: Boolean) : StorageClass = copy(allowVolumeExpansion = Some(value))
  def withAllowedTopologies(value: Seq[io.k8s.api.core.v1.TopologySelectorTerm]) : StorageClass = copy(allowedTopologies = Some(value))
  def addAllowedTopologies(newValues: io.k8s.api.core.v1.TopologySelectorTerm*) : StorageClass = copy(allowedTopologies = Some(allowedTopologies.fold(newValues)(_ ++ newValues)))

  def withParameters(value: Map[String, String]) : StorageClass = copy(parameters = Some(value))
  def addParameters(newValues: (String, String)*) : StorageClass = copy(parameters = Some(parameters.fold(newValues.toMap)(_ ++ newValues)))

}

