package io.k8s.api.storage.v1

import dev.hnaderi.k8s._

/** CSIStorageCapacityList is a collection of CSIStorageCapacity objects. */
final case class CSIStorageCapacityList(
  items : Seq[io.k8s.api.storage.v1.CSIStorageCapacity],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("storage.k8s.io", "CSIStorageCapacityList", "v1")

  def withItems(value: Seq[io.k8s.api.storage.v1.CSIStorageCapacity]) : CSIStorageCapacityList = copy(items = value)
  def addItems(newValues: io.k8s.api.storage.v1.CSIStorageCapacity*) : CSIStorageCapacityList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : CSIStorageCapacityList = copy(metadata = Some(value))
}

