package io.k8s.api.storage.v1


/** CSINodeSpec holds information about the specification of all CSI drivers installed on a node */
final case class CSINodeSpec(
  drivers : Seq[io.k8s.api.storage.v1.CSINodeDriver]
) {
  def withDrivers(value: Seq[io.k8s.api.storage.v1.CSINodeDriver]) : CSINodeSpec = copy(drivers = value)
  def addDrivers(newValues: io.k8s.api.storage.v1.CSINodeDriver*) : CSINodeSpec = copy(drivers = drivers ++ newValues)

}

