package io.k8s.api.storage.v1

import dev.hnaderi.k8s._

/** CSINode holds information about all CSI drivers installed on a node. CSI drivers do not need to create the CSINode object directly. As long as they use the node-driver-registrar sidecar container, the kubelet will automatically populate the CSINode object for the CSI driver as part of kubelet plugin registration. CSINode has the same name as a node. If the object is missing, it means either there are no CSI Drivers available on the node, or the Kubelet version is low enough that it doesn't create this object. CSINode has an OwnerReference that points to the corresponding node object. */
final case class CSINode(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec : io.k8s.api.storage.v1.CSINodeSpec
) extends KObject {
  protected val _resourceKind = ResourceKind("storage.k8s.io", "CSINode", "v1")

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : CSINode = copy(metadata = Some(value))
  def withSpec(value: io.k8s.api.storage.v1.CSINodeSpec) : CSINode = copy(spec = value)
}

