package io.k8s.api.storage.v1


/** CSIDriverSpec is the specification of a CSIDriver. */
final case class CSIDriverSpec(
  volumeLifecycleModes : Option[Seq[String]] = None,
  podInfoOnMount : Option[Boolean] = None,
  attachRequired : Option[Boolean] = None,
  requiresRepublish : Option[Boolean] = None,
  fsGroupPolicy : Option[String] = None,
  storageCapacity : Option[Boolean] = None,
  tokenRequests : Option[Seq[io.k8s.api.storage.v1.TokenRequest]] = None,
  seLinuxMount : Option[Boolean] = None
) {
  def withVolumeLifecycleModes(value: Seq[String]) : CSIDriverSpec = copy(volumeLifecycleModes = Some(value))
  def addVolumeLifecycleModes(newValues: String*) : CSIDriverSpec = copy(volumeLifecycleModes = Some(volumeLifecycleModes.fold(newValues)(_ ++ newValues)))

  def withPodInfoOnMount(value: Boolean) : CSIDriverSpec = copy(podInfoOnMount = Some(value))
  def withAttachRequired(value: Boolean) : CSIDriverSpec = copy(attachRequired = Some(value))
  def withRequiresRepublish(value: Boolean) : CSIDriverSpec = copy(requiresRepublish = Some(value))
  def withFsGroupPolicy(value: String) : CSIDriverSpec = copy(fsGroupPolicy = Some(value))
  def withStorageCapacity(value: Boolean) : CSIDriverSpec = copy(storageCapacity = Some(value))
  def withTokenRequests(value: Seq[io.k8s.api.storage.v1.TokenRequest]) : CSIDriverSpec = copy(tokenRequests = Some(value))
  def addTokenRequests(newValues: io.k8s.api.storage.v1.TokenRequest*) : CSIDriverSpec = copy(tokenRequests = Some(tokenRequests.fold(newValues)(_ ++ newValues)))

  def withSeLinuxMount(value: Boolean) : CSIDriverSpec = copy(seLinuxMount = Some(value))
}

