package io.k8s.api.storage.v1

import dev.hnaderi.k8s._

/** CSIDriverList is a collection of CSIDriver objects. */
final case class CSIDriverList(
  items : Seq[io.k8s.api.storage.v1.CSIDriver],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("storage.k8s.io", "CSIDriverList", "v1")

  def withItems(value: Seq[io.k8s.api.storage.v1.CSIDriver]) : CSIDriverList = copy(items = value)
  def addItems(newValues: io.k8s.api.storage.v1.CSIDriver*) : CSIDriverList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : CSIDriverList = copy(metadata = Some(value))
}

