package io.k8s.api.rbac.v1


/** Subject contains a reference to the object or user identities a role binding applies to.  This can either hold a direct API object reference, or a value for non-objects such as user and group names. */
final case class Subject(
  apiGroup : Option[String] = None,
  name : String,
  namespace : Option[String] = None
) {
  def withApiGroup(value: String) : Subject = copy(apiGroup = Some(value))
  def withName(value: String) : Subject = copy(name = value)
  def withNamespace(value: String) : Subject = copy(namespace = Some(value))
}

