package io.k8s.api.rbac.v1

import dev.hnaderi.k8s._

/** RoleList is a collection of Roles */
final case class RoleList(
  items : Seq[io.k8s.api.rbac.v1.Role],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("rbac.authorization.k8s.io", "RoleList", "v1")

  def withItems(value: Seq[io.k8s.api.rbac.v1.Role]) : RoleList = copy(items = value)
  def addItems(newValues: io.k8s.api.rbac.v1.Role*) : RoleList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : RoleList = copy(metadata = Some(value))
}

