package io.k8s.api.rbac.v1

import dev.hnaderi.k8s._

/** RoleBindingList is a collection of RoleBindings */
final case class RoleBindingList(
  items : Seq[io.k8s.api.rbac.v1.RoleBinding],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("rbac.authorization.k8s.io", "RoleBindingList", "v1")

  def withItems(value: Seq[io.k8s.api.rbac.v1.RoleBinding]) : RoleBindingList = copy(items = value)
  def addItems(newValues: io.k8s.api.rbac.v1.RoleBinding*) : RoleBindingList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : RoleBindingList = copy(metadata = Some(value))
}

