package io.k8s.api.rbac.v1

import dev.hnaderi.k8s._

/** RoleBinding references a role, but does not contain it.  It can reference a Role in the same namespace or a ClusterRole in the global namespace. It adds who information via Subjects and namespace information by which namespace it exists in.  RoleBindings in a given namespace only have effect in that namespace. */
final case class RoleBinding(
  subjects : Option[Seq[io.k8s.api.rbac.v1.Subject]] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  roleRef : io.k8s.api.rbac.v1.RoleRef
) extends KObject {
  protected val _resourceKind = ResourceKind("rbac.authorization.k8s.io", "RoleBinding", "v1")

  def withSubjects(value: Seq[io.k8s.api.rbac.v1.Subject]) : RoleBinding = copy(subjects = Some(value))
  def addSubjects(newValues: io.k8s.api.rbac.v1.Subject*) : RoleBinding = copy(subjects = Some(subjects.fold(newValues)(_ ++ newValues)))

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : RoleBinding = copy(metadata = Some(value))
  def withRoleRef(value: io.k8s.api.rbac.v1.RoleRef) : RoleBinding = copy(roleRef = value)
}

