package io.k8s.api.rbac.v1

import dev.hnaderi.k8s._

/** Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding. */
final case class Role(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  rules : Option[Seq[io.k8s.api.rbac.v1.PolicyRule]] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("rbac.authorization.k8s.io", "Role", "v1")

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Role = copy(metadata = Some(value))
  def withRules(value: Seq[io.k8s.api.rbac.v1.PolicyRule]) : Role = copy(rules = Some(value))
  def addRules(newValues: io.k8s.api.rbac.v1.PolicyRule*) : Role = copy(rules = Some(rules.fold(newValues)(_ ++ newValues)))

}

