package io.k8s.api.rbac.v1

import dev.hnaderi.k8s._

/** ClusterRoleList is a collection of ClusterRoles */
final case class ClusterRoleList(
  items : Seq[io.k8s.api.rbac.v1.ClusterRole],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("rbac.authorization.k8s.io", "ClusterRoleList", "v1")

  def withItems(value: Seq[io.k8s.api.rbac.v1.ClusterRole]) : ClusterRoleList = copy(items = value)
  def addItems(newValues: io.k8s.api.rbac.v1.ClusterRole*) : ClusterRoleList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ClusterRoleList = copy(metadata = Some(value))
}

