package io.k8s.api.rbac.v1

import dev.hnaderi.k8s._

/** ClusterRoleBindingList is a collection of ClusterRoleBindings */
final case class ClusterRoleBindingList(
  items : Seq[io.k8s.api.rbac.v1.ClusterRoleBinding],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("rbac.authorization.k8s.io", "ClusterRoleBindingList", "v1")

  def withItems(value: Seq[io.k8s.api.rbac.v1.ClusterRoleBinding]) : ClusterRoleBindingList = copy(items = value)
  def addItems(newValues: io.k8s.api.rbac.v1.ClusterRoleBinding*) : ClusterRoleBindingList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ClusterRoleBindingList = copy(metadata = Some(value))
}

