package io.k8s.api.rbac.v1

import dev.hnaderi.k8s._

/** ClusterRoleBinding references a ClusterRole, but not contain it.  It can reference a ClusterRole in the global namespace, and adds who information via Subject. */
final case class ClusterRoleBinding(
  subjects : Option[Seq[io.k8s.api.rbac.v1.Subject]] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  roleRef : io.k8s.api.rbac.v1.RoleRef
) extends KObject {
  protected val _resourceKind = ResourceKind("rbac.authorization.k8s.io", "ClusterRoleBinding", "v1")

  def withSubjects(value: Seq[io.k8s.api.rbac.v1.Subject]) : ClusterRoleBinding = copy(subjects = Some(value))
  def addSubjects(newValues: io.k8s.api.rbac.v1.Subject*) : ClusterRoleBinding = copy(subjects = Some(subjects.fold(newValues)(_ ++ newValues)))

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ClusterRoleBinding = copy(metadata = Some(value))
  def withRoleRef(value: io.k8s.api.rbac.v1.RoleRef) : ClusterRoleBinding = copy(roleRef = value)
}

