package io.k8s.api.rbac.v1


/** AggregationRule describes how to locate ClusterRoles to aggregate into the ClusterRole */
final case class AggregationRule(
  clusterRoleSelectors : Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]] = None
) {
  def withClusterRoleSelectors(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]) : AggregationRule = copy(clusterRoleSelectors = Some(value))
  def addClusterRoleSelectors(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector*) : AggregationRule = copy(clusterRoleSelectors = Some(clusterRoleSelectors.fold(newValues)(_ ++ newValues)))

}

