package io.k8s.api.policy.v1


/** PodDisruptionBudgetStatus represents information about the status of a PodDisruptionBudget. Status may trail the actual state of a system. */
final case class PodDisruptionBudgetStatus(
  conditions : Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]] = None,
  disruptionsAllowed : Int,
  disruptedPods : Option[Map[String, io.k8s.apimachinery.pkg.apis.meta.v1.Time]] = None,
  desiredHealthy : Int,
  expectedPods : Int,
  observedGeneration : Option[Int] = None,
  currentHealthy : Int
) {
  def withConditions(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]) : PodDisruptionBudgetStatus = copy(conditions = Some(value))
  def addConditions(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.Condition*) : PodDisruptionBudgetStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))

  def withDisruptionsAllowed(value: Int) : PodDisruptionBudgetStatus = copy(disruptionsAllowed = value)
  def withDisruptedPods(value: Map[String, io.k8s.apimachinery.pkg.apis.meta.v1.Time]) : PodDisruptionBudgetStatus = copy(disruptedPods = Some(value))
  def addDisruptedPods(newValues: (String, io.k8s.apimachinery.pkg.apis.meta.v1.Time)*) : PodDisruptionBudgetStatus = copy(disruptedPods = Some(disruptedPods.fold(newValues.toMap)(_ ++ newValues)))

  def withDesiredHealthy(value: Int) : PodDisruptionBudgetStatus = copy(desiredHealthy = value)
  def withExpectedPods(value: Int) : PodDisruptionBudgetStatus = copy(expectedPods = value)
  def withObservedGeneration(value: Int) : PodDisruptionBudgetStatus = copy(observedGeneration = Some(value))
  def withCurrentHealthy(value: Int) : PodDisruptionBudgetStatus = copy(currentHealthy = value)
}

