package io.k8s.api.policy.v1


/** PodDisruptionBudgetSpec is a description of a PodDisruptionBudget. */
final case class PodDisruptionBudgetSpec(
  maxUnavailable : Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString] = None,
  minAvailable : Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString] = None,
  selector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None
) {
  def withMaxUnavailable(value: io.k8s.apimachinery.pkg.util.intstr.IntOrString) : PodDisruptionBudgetSpec = copy(maxUnavailable = Some(value))
  def withMinAvailable(value: io.k8s.apimachinery.pkg.util.intstr.IntOrString) : PodDisruptionBudgetSpec = copy(minAvailable = Some(value))
  def withSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : PodDisruptionBudgetSpec = copy(selector = Some(value))
}

