package io.k8s.api.policy.v1

import dev.hnaderi.k8s._

/** PodDisruptionBudgetList is a collection of PodDisruptionBudgets. */
final case class PodDisruptionBudgetList(
  items : Seq[io.k8s.api.policy.v1.PodDisruptionBudget],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("policy", "PodDisruptionBudgetList", "v1")

  def withItems(value: Seq[io.k8s.api.policy.v1.PodDisruptionBudget]) : PodDisruptionBudgetList = copy(items = value)
  def addItems(newValues: io.k8s.api.policy.v1.PodDisruptionBudget*) : PodDisruptionBudgetList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : PodDisruptionBudgetList = copy(metadata = Some(value))
}

