package io.k8s.api.policy.v1

import dev.hnaderi.k8s._

/** PodDisruptionBudget is an object to define the max disruption that can be caused to a collection of pods */
final case class PodDisruptionBudget(
  status : Option[io.k8s.api.policy.v1.PodDisruptionBudgetStatus] = None,
  spec : Option[io.k8s.api.policy.v1.PodDisruptionBudgetSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("policy", "PodDisruptionBudget", "v1")

  def withStatus(value: io.k8s.api.policy.v1.PodDisruptionBudgetStatus) : PodDisruptionBudget = copy(status = Some(value))
  def withSpec(value: io.k8s.api.policy.v1.PodDisruptionBudgetSpec) : PodDisruptionBudget = copy(spec = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PodDisruptionBudget = copy(metadata = Some(value))
}

