package io.k8s.api.node.v1

import dev.hnaderi.k8s._

/** RuntimeClass defines a class of container runtime supported in the cluster. The RuntimeClass is used to determine which container runtime is used to run all containers in a pod. RuntimeClasses are manually defined by a user or cluster provisioner, and referenced in the PodSpec. The Kubelet is responsible for resolving the RuntimeClassName reference before running the pod.  For more details, see https://kubernetes.io/docs/concepts/containers/runtime-class/ */
final case class RuntimeClass(
  scheduling : Option[io.k8s.api.node.v1.Scheduling] = None,
  overhead : Option[io.k8s.api.node.v1.Overhead] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  handler : String
) extends KObject {
  protected val _resourceKind = ResourceKind("node.k8s.io", "RuntimeClass", "v1")

  def withScheduling(value: io.k8s.api.node.v1.Scheduling) : RuntimeClass = copy(scheduling = Some(value))
  def withOverhead(value: io.k8s.api.node.v1.Overhead) : RuntimeClass = copy(overhead = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : RuntimeClass = copy(metadata = Some(value))
  def withHandler(value: String) : RuntimeClass = copy(handler = value)
}

