package io.k8s.api.networking.v1alpha1


/** ClusterCIDRSpec defines the desired state of ClusterCIDR. */
final case class ClusterCIDRSpec(
  ipv4 : Option[String] = None,
  ipv6 : Option[String] = None,
  nodeSelector : Option[io.k8s.api.core.v1.NodeSelector] = None,
  perNodeHostBits : Int
) {
  def withIpv4(value: String) : ClusterCIDRSpec = copy(ipv4 = Some(value))
  def withIpv6(value: String) : ClusterCIDRSpec = copy(ipv6 = Some(value))
  def withNodeSelector(value: io.k8s.api.core.v1.NodeSelector) : ClusterCIDRSpec = copy(nodeSelector = Some(value))
  def withPerNodeHostBits(value: Int) : ClusterCIDRSpec = copy(perNodeHostBits = value)
}

