package io.k8s.api.networking.v1alpha1

import dev.hnaderi.k8s._

/** ClusterCIDRList contains a list of ClusterCIDR. */
final case class ClusterCIDRList(
  items : Seq[io.k8s.api.networking.v1alpha1.ClusterCIDR],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("networking.k8s.io", "ClusterCIDRList", "v1alpha1")

  def withItems(value: Seq[io.k8s.api.networking.v1alpha1.ClusterCIDR]) : ClusterCIDRList = copy(items = value)
  def addItems(newValues: io.k8s.api.networking.v1alpha1.ClusterCIDR*) : ClusterCIDRList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ClusterCIDRList = copy(metadata = Some(value))
}

