package io.k8s.api.networking.v1alpha1

import dev.hnaderi.k8s._

/** ClusterCIDR represents a single configuration for per-Node Pod CIDR allocations when the MultiCIDRRangeAllocator is enabled (see the config for kube-controller-manager).  A cluster may have any number of ClusterCIDR resources, all of which will be considered when allocating a CIDR for a Node.  A ClusterCIDR is eligible to be used for a given Node when the node selector matches the node in question and has free CIDRs to allocate.  In case of multiple matching ClusterCIDR resources, the allocator will attempt to break ties using internal heuristics, but any ClusterCIDR whose node selector matches the Node may be used. */
final case class ClusterCIDR(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec : Option[io.k8s.api.networking.v1alpha1.ClusterCIDRSpec] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("networking.k8s.io", "ClusterCIDR", "v1alpha1")

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ClusterCIDR = copy(metadata = Some(value))
  def withSpec(value: io.k8s.api.networking.v1alpha1.ClusterCIDRSpec) : ClusterCIDR = copy(spec = Some(value))
}

