package io.k8s.api.networking.v1


/** NetworkPolicySpec provides the specification of a NetworkPolicy */
final case class NetworkPolicySpec(
  egress : Option[Seq[io.k8s.api.networking.v1.NetworkPolicyEgressRule]] = None,
  ingress : Option[Seq[io.k8s.api.networking.v1.NetworkPolicyIngressRule]] = None,
  podSelector : io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector,
  policyTypes : Option[Seq[String]] = None
) {
  def withEgress(value: Seq[io.k8s.api.networking.v1.NetworkPolicyEgressRule]) : NetworkPolicySpec = copy(egress = Some(value))
  def addEgress(newValues: io.k8s.api.networking.v1.NetworkPolicyEgressRule*) : NetworkPolicySpec = copy(egress = Some(egress.fold(newValues)(_ ++ newValues)))

  def withIngress(value: Seq[io.k8s.api.networking.v1.NetworkPolicyIngressRule]) : NetworkPolicySpec = copy(ingress = Some(value))
  def addIngress(newValues: io.k8s.api.networking.v1.NetworkPolicyIngressRule*) : NetworkPolicySpec = copy(ingress = Some(ingress.fold(newValues)(_ ++ newValues)))

  def withPodSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : NetworkPolicySpec = copy(podSelector = value)
  def withPolicyTypes(value: Seq[String]) : NetworkPolicySpec = copy(policyTypes = Some(value))
  def addPolicyTypes(newValues: String*) : NetworkPolicySpec = copy(policyTypes = Some(policyTypes.fold(newValues)(_ ++ newValues)))

}

