package io.k8s.api.networking.v1


/** NetworkPolicyPort describes a port to allow traffic on */
final case class NetworkPolicyPort(
  endPort : Option[Int] = None,
  port : Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString] = None,
  protocol : Option[String] = None
) {
  def withEndPort(value: Int) : NetworkPolicyPort = copy(endPort = Some(value))
  def withPort(value: io.k8s.apimachinery.pkg.util.intstr.IntOrString) : NetworkPolicyPort = copy(port = Some(value))
  def withProtocol(value: String) : NetworkPolicyPort = copy(protocol = Some(value))
}

