package io.k8s.api.networking.v1


/** NetworkPolicyPeer describes a peer to allow traffic to/from. Only certain combinations of fields are allowed */
final case class NetworkPolicyPeer(
  ipBlock : Option[io.k8s.api.networking.v1.IPBlock] = None,
  namespaceSelector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None,
  podSelector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None
) {
  def withIpBlock(value: io.k8s.api.networking.v1.IPBlock) : NetworkPolicyPeer = copy(ipBlock = Some(value))
  def withNamespaceSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : NetworkPolicyPeer = copy(namespaceSelector = Some(value))
  def withPodSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : NetworkPolicyPeer = copy(podSelector = Some(value))
}

